package com.agilex.healthcare.directscheduling.exception;

import gov.va.vamf.scheduling.direct.domain.ValidationError;

public class AppointmentException extends RuntimeException {

    private static final long serialVersionUID = -8153682473228733547L;

    private final ValidationError error;

    public AppointmentException(ValidationError error){

        this.error = error;
    }

    public ValidationError getError(){
        return error;
    }

    public String getErrorMessageForLogging(int statusCode) {
        String message = this.getMessage();

        if (this.getError() != null) {
            if (message == null)
                message = this.getError().getErrorMessage();
            else
                message += "\n" + this.getError().getErrorMessage();
        }
        return "Appointment exception (" + statusCode + "): " + message;
    }
}
